<?php
/**
 *
 * @package Modality
 */
$modality_theme_options = modality_get_options( 'modality_theme_options' );
get_header(); ?>
<div id="main" class="<?php echo esc_attr($modality_theme_options['portfolio_layout_settings']);?>">
<div class="content-posts-wrap">
	<div id="content-box">
		<div id="post-body">
			<div <?php post_class('post-single'); ?>>
				<h1 id="post-title" <?php post_class('entry-title'); ?>><?php the_title(); ?> </h1>
				<?php 
				if ($modality_theme_options['breadcrumbs'] == '1') { ?>
				<div class="breadcrumbs">
					<div class="breadcrumbs-wrap"> 
						<?php get_template_part( 'breadcrumbs'); ?>
					</div><!--breadcrumbs-wrap-->
				</div><!--breadcrumbs-->
			<?php } ?>
				<div id="portfolio" class="<?php echo $modality_theme_options['portfolio_columns']; ?>">
				
					<?php
					$portfolio_category = get_terms('portfolio_skills');
					if($portfolio_category):
					?>
					<ul class="portfolio-tabs clearfix">
						<li class="active"><a data-filter="*" href="#"><?php echo __('All', 'modality'); ?></a></li>
						<?php foreach($portfolio_category as $portfolio_cat): ?>
							<li><a data-filter=".<?php echo $portfolio_cat->slug; ?>" href="#"><?php echo $portfolio_cat->name; ?></a></li>
						<?php endforeach; ?>
					</ul>
					<?php endif; ?>	
					<div class="clear"></div>
					<div id="portfolio-wrapper">
						<?php $portfolio_query = new WP_Query(
										array(
											'posts_per_page' => $modality_theme_options['portfolio_items'],
											'post_type' => 'portfolio',
											)
										);?>
						<?php while ( $portfolio_query->have_posts() ): $portfolio_query->the_post(); ?>
						<?php
						$item_classes = '';
						$item_cats = get_the_terms($post->ID, 'portfolio_skills');
						if($item_cats):
							foreach($item_cats as $item_cat) {
								$item_classes .= $item_cat->slug . ' ';
							}
						endif;
						?>
						<div class="portfolio-item <?php echo $item_classes; ?>">
							<figure class="<?php echo $modality_theme_options['portfolio_effect']?> imgLiquidFill imgLiquid">
								<?php if ($modality_theme_options['pretty_photo'] == '1') {?> 
									<?php $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'large'); ?>
									<a href="<?php echo $large_image_url[0]; ?>" rel="prettyPhoto[pp_gal]">										
								<?php } else { ?>
									<a class="item_link" title="<?php the_title(); ?>" href="<?php the_permalink(); ?>">
								<?php } ?>
									
										<?php the_post_thumbnail('full'); ?>
								
									<figcaption>
										<div>
											<h2><?php the_title(); ?></h2>
											<?php the_excerpt();?>
										</div>
									</figcaption>
								</a>
							</figure>
						</div><!--portfolio-item-->
						<?php endwhile; wp_reset_query(); ?>
					
					</div><!--portfolio-wrapper-->
				</div><!--portfolio-->
			</div><!--post-single-->
				<?php get_template_part('post','sidebar'); ?>
		</div><!--post-body-->
	</div><!--content-box-->
	<div class="sidebar-frame">
		<div class="sidebar">
			<?php get_sidebar(); ?>
		</div><!--sidebar-->
	</div><!--sidebar-frame-->
</div><!--content-posts-wrap-->
</div><!--main-->
<?php if ($modality_theme_options['social_section_on'] == '1') {
	get_template_part( 'social', 'section' );	
}
get_footer(); ?>
<script type="text/javascript">
	var pretty=jQuery.noConflict();
		pretty(document).ready(function(){
		pretty("[rel^='prettyPhoto']").prettyPhoto();
	});
</script>	