<?php
/**
 * Template Name: Contact Page
 *
 * @package Modality
 */
$modality_theme_options = modality_get_options( 'modality_theme_options' );
get_header(); 
wp_enqueue_script('gmap', 'http://maps.google.com/maps/api/js?sensor=false', array( 'jquery' ),'', true);
wp_enqueue_script('jquery.ui.map', get_template_directory_uri() . '/js/gmap.js', array( 'jquery' ),'', true); ?>

<div id="main" class="col1">
	<?php
		// Start the Loop.
		while ( have_posts() ) : the_post(); ?>

<div class="content-posts-wrap">
	<div id="content-box">
		<div id="post-body">
			<div <?php post_class('post-single'); ?>>
				<h1 id="post-title" <?php post_class('entry-title'); ?>><?php the_title(); ?> </h1>
				<?php 
				if ($modality_theme_options['breadcrumbs'] == '1') { ?>
				<div class="breadcrumbs">
					<div class="breadcrumbs-wrap"> 
						<?php get_template_part( 'breadcrumbs'); ?>
					</div><!--breadcrumbs-wrap-->
				</div><!--breadcrumbs-->
			<?php } ?>
			<div class="gmap" id="gmap">
			</div>
		<div class="contact-info">
			<div class="one_third">
				<div class="box-icon">
					<span>
						<i class="fa fa-map-marker"></i>
					</span>
				</div>
				<h4 class="box-title"><?php _e('Office Address','modality'); ?></h4>
				<div class="box-content">
					<?php echo $modality_theme_options['contact_address']; ?>
				</div>
			</div>
			<div class="one_third">
				<div class="box-icon">
					<span>
						<i class="fa fa-phone"></i>
					</span>
				</div>
				<h4 class="box-title"><?php _e('Phone Number','modality'); ?></h4>
				<div class="box-content">
					<?php echo $modality_theme_options['contact_phone']; ?>
				</div>
			</div>
			<div class="one_third last">
				<div class="box-icon">
					<span>
						<i class="fa fa-envelope-o"></i>
					</span>
				</div>
				<h4 class="box-title"><?php _e('Email ID','modality'); ?></h4>
				<div class="box-content">
					<?php echo $modality_theme_options['contact_email']; ?>
				</div>	
			</div>
		</div>
		<div class="clear"></div>
				<div id="article">
					<?php the_content(); ?>
			
				</div><!--article-->
			</div><!--post-single-->
				<?php get_template_part('post','sidebar'); ?>
		</div><!--post-body-->
	</div><!--content-box-->
	<div class="sidebar-frame">
		<div class="sidebar">
			<?php get_sidebar(); ?>
		</div><!--sidebar-->
	</div><!--sidebar-frame-->
</div><!--content-posts-wrap-->
<?php
$addresses = explode('|', $modality_theme_options['gmap_address']);
	$markers = '';
	foreach($addresses as $address_string) {
		$markers .= "{
			address: '{$address_string}',
			html: {
				content: '{$address_string}',
				popup: true
				} 
			},";	
	}
		
		endwhile;
	?>
<script type='text/javascript'>
	var gomap=jQuery.noConflict()
	gomap(document).ready(function($) {
		gomap('#gmap').goMap({
			address: '<?php echo $addresses[0]; ?>',
			maptype: '<?php echo $modality_theme_options['gmap_type']; ?>',
			zoom: <?php echo $modality_theme_options['map_zoom_level']; ?>,
			scrollwheel: <?php if($modality_theme_options['map_scrollwheel']): ?>true<?php else: ?>false<?php endif; ?>,
			scaleControl: <?php if($modality_theme_options['map_scale']): ?>true<?php else: ?>false<?php endif; ?>,
			navigationControl: <?php if($modality_theme_options['map_zoomcontrol']): ?>true<?php else: ?>false<?php endif; ?>,
	        markers: [<?php echo $markers; ?>]
		});
	});
</script>
</div><!--main-->
<?php if ($modality_theme_options['social_section_on'] == '1') {
	get_template_part( 'social', 'section' );	
}
get_footer(); ?>